/*
 * Decompiled with CFR 0.152.
 */
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.Label;
import java.awt.TextField;

class AdvancedDialog
extends GenericDialog
implements DialogListener {
    boolean ok = true;
    int nframes;

    AdvancedDialog(String string, int n) {
        super("3B Analysis");
        this.nframes = n;
        this.addMessage("Advanced configuration");
        this.addMessage("                                 ");
        this.addCheckbox("I understand 3B enough to be editing the text below", false);
        this.addTextAreas(string, null, 40, 100);
        this.addNumericField("Pixel size (nm / pixel)", 100.0, 1, 10, "nm");
        this.addNumericField("First frame", 0.0, 0, 10, "");
        this.addNumericField("Last frame", (double)this.nframes - 1.0, 0, 10, "");
        this.addDialogListener(this);
        this.dialogItemChanged(null, null);
        this.showDialog();
    }

    public boolean dialogItemChanged(GenericDialog genericDialog, AWTEvent aWTEvent) {
        boolean bl = ((Checkbox)this.getCheckboxes().get(0)).getState();
        if (bl != this.ok) {
            this.ok = bl;
            if (this.ok) {
                this.getTextArea1().setEditable(true);
                ((Label)this.getMessage()).setText("Warning: strange behaviour may result!");
                this.getPixelSizeField().setEditable(true);
                this.getFirstFrameField().setEditable(true);
                this.getLastFrameField().setEditable(true);
            } else {
                this.getTextArea1().setEditable(false);
                ((Label)this.getMessage()).setText("                                             ");
                this.getPixelSizeField().setEditable(false);
                this.getFirstFrameField().setEditable(false);
                this.getLastFrameField().setEditable(false);
            }
        }
        int n = this.getFirstFrame();
        int n2 = this.getLastFrame();
        int n3 = Math.max(0, Math.min(this.nframes - 1, n));
        int n4 = Math.max(n3, Math.min(this.nframes - 1, n2));
        if (n != n3) {
            this.getFirstFrameField().setText(Integer.toString(n3));
        }
        if (n2 != n4) {
            this.getLastFrameField().setText(Integer.toString(n4));
        }
        return this.ok;
    }

    int parseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public double parseDouble(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    TextField getPixelSizeField() {
        return (TextField)this.getNumericFields().get(0);
    }

    TextField getFirstFrameField() {
        return (TextField)this.getNumericFields().get(1);
    }

    TextField getLastFrameField() {
        return (TextField)this.getNumericFields().get(2);
    }

    double getPixelSize() {
        return this.parseDouble(this.getPixelSizeField().getText());
    }

    int getFirstFrame() {
        return this.parseInt(this.getFirstFrameField().getText());
    }

    int getLastFrame() {
        return this.parseInt(this.getLastFrameField().getText());
    }
}

