/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class FloatSliderWithBox
extends JPanel {
    private JSlider slider;
    private JTextField number;
    private JLabel label;
    private GridBagConstraints completePanelConstraints_;
    private int steps = 1000000;
    private double min;
    private double max;
    private String text;
    private String units;
    private String format = "%8.3f";
    private double value;
    private boolean reciprocal;

    public FloatSliderWithBox(String string, double d, double d2, double d3, int n, boolean bl) {
        super(new GridBagLayout());
        this.reciprocal = bl;
        this.min = d;
        this.max = d2;
        this.text = string;
        this.value = d3;
        if (this.reciprocal) {
            this.min = 1.0 / d2;
            this.max = 1.0 / d;
        }
        this.slider = new JSlider(0, this.steps);
        this.label = new JLabel();
        this.number = new JTextField(n);
        this.completePanelConstraints_ = new GridBagConstraints();
        this.completePanelConstraints_.fill = 2;
        this.completePanelConstraints_.gridx = 0;
        this.completePanelConstraints_.gridy = 0;
        this.completePanelConstraints_.weightx = 1.0;
        this.add((Component)this.slider, this.completePanelConstraints_);
        this.completePanelConstraints_.gridx = 2;
        this.completePanelConstraints_.gridy = 0;
        this.completePanelConstraints_.weightx = 0.0;
        this.add((Component)this.label, this.completePanelConstraints_);
        this.completePanelConstraints_.gridx = 1;
        this.completePanelConstraints_.gridy = 0;
        this.completePanelConstraints_.weightx = 0.0;
        this.completePanelConstraints_.insets = new Insets(0, 5, 10, 0);
        this.add((Component)this.number, this.completePanelConstraints_);
        this.setBorder(BorderFactory.createTitledBorder(this.text));
        this.slider.addChangeListener(new SliderChanged(this));
        this.number.addActionListener(new TextChanged(this));
        this.setValue(this.value);
    }

    public FloatSliderWithBox setUnits(String string) {
        this.units = string;
        this.setValue(this.value);
        return this;
    }

    public FloatSliderWithBox setFormat(String string) {
        this.format = string;
        this.setValue(this.value);
        return this;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.slider.addChangeListener(changeListener);
    }

    void setValue(double d) {
        this.value = d;
        if (this.reciprocal) {
            this.slider.setValue((int)Math.round((double)this.steps * (1.0 / this.value - this.min) / (this.max - this.min)));
        } else {
            this.slider.setValue((int)Math.round((double)this.steps * (this.value - this.min) / (this.max - this.min)));
        }
        this.number.setText(String.format(this.format, this.value));
        this.label.setText(this.units);
    }

    double getValue() {
        return this.value;
    }

    public double get_value_from_slider() {
        if (this.reciprocal) {
            return 1.0 / ((double)this.slider.getValue() * 1.0 / (double)this.steps * (this.max - this.min) + this.min);
        }
        return (double)this.slider.getValue() * 1.0 / (double)this.steps * (this.max - this.min) + this.min;
    }

    public double get_value_from_text() {
        return Double.parseDouble(this.number.getText());
    }

    class TextChanged
    implements ActionListener {
        FloatSliderWithBox f;

        TextChanged(FloatSliderWithBox floatSliderWithBox2) {
            this.f = floatSliderWithBox2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.f.setValue(this.f.get_value_from_text());
        }
    }

    class SliderChanged
    implements ChangeListener {
        FloatSliderWithBox f;

        SliderChanged(FloatSliderWithBox floatSliderWithBox2) {
            this.f = floatSliderWithBox2;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.f.setValue(this.f.get_value_from_slider());
        }
    }
}

