/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.plugin.filter.GaussianBlur;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class EControlPanel
extends JFrame
implements WindowListener {
    private ImagePlus linear_reconstruction;
    private ImageCanvas canvas;
    private JButton stopButton;
    private JButton exportButton;
    private JButton closeButton;
    private Color exportButtonColor;
    private JLabel status;
    private JLabel time_msg;
    private FloatSliderWithBox blur_fwhm;
    private FloatSliderWithBox reconstructed_pixel_size;
    private Panel complete;
    private JPanel buttons;
    private ThreeBRunner tbr;
    private ArrayList<Spot> pts;
    private Rectangle roi;
    private double zoom = 0.01;
    private double reconstruction_blur_fwhm = 0.5;
    private double pixel_size_in_nm;
    private String filename;
    private int iterations = 0;

    EControlPanel(Rectangle rectangle, double d, String string, ThreeBRunner threeBRunner) {
        super(string);
        this.tbr = threeBRunner;
        this.filename = string;
        this.roi = rectangle;
        this.pixel_size_in_nm = d;
        this.pts = new ArrayList();
        this.complete = new Panel(new GridBagLayout());
        this.linear_reconstruction = new ImagePlus();
        this.linear_reconstruction.setProcessor((ImageProcessor)this.reconstruct());
        this.canvas = new ImageCanvas(this.linear_reconstruction);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.add((Component)this.canvas);
        this.complete.add((Component)scrollPane, this.canvas_pos());
        this.status = new JLabel();
        if (this.tbr != null) {
            this.set_status("Running.");
        } else {
            this.set_status("Using loaded data.");
        }
        this.complete.add((Component)this.status, this.status_pos());
        this.time_msg = new JLabel();
        if (this.tbr != null) {
            this.set_time("unknown");
        } else {
            this.set_time("not running");
        }
        this.complete.add((Component)this.time_msg, this.time_pos());
        this.blur_fwhm = new FloatSliderWithBox("Reconstruction blur FWHM", 0.0, 150.0, 100.0, 5, false);
        this.blur_fwhm.setUnits("nm").setFormat("%5.1f");
        this.blur_fwhm.addChangeListener(new SomethingChanges(this));
        this.complete.add((Component)this.blur_fwhm, this.blur_pos());
        this.reconstructed_pixel_size = new FloatSliderWithBox("Reconstructed pixel size", 1.0, 300.0, 10.0, 5, true);
        this.reconstructed_pixel_size.setUnits("nm").setFormat("%5.1f");
        this.reconstructed_pixel_size.addChangeListener(new SomethingChanges(this));
        this.complete.add((Component)this.reconstructed_pixel_size, this.pixel_size_pos());
        this.buttons = new JPanel();
        this.exportButton = new JButton("Export...");
        this.exportButton.addActionListener(new ExportButtonListener(this));
        this.buttons.add(this.exportButton);
        this.exportButtonColor = this.exportButton.getBackground();
        if (this.tbr != null) {
            this.stopButton = new JButton("Stop");
            this.stopButton.addActionListener(new StopButtonListener(this));
            this.buttons.add(this.stopButton);
        }
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new CloseButtonListener(this));
        this.buttons.add(this.closeButton);
        this.complete.add((Component)this.buttons, this.buttons_pos());
        this.getContentPane().add(this.complete);
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setVisible(true);
        this.validate();
        if (this.tbr != null) {
            this.tbr.register(this);
            Thread thread = new Thread(this.tbr);
            thread.start();
        }
    }

    private GridBagConstraints canvas_pos() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        return gridBagConstraints;
    }

    private GridBagConstraints status_pos() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 1;
        return gridBagConstraints;
    }

    private GridBagConstraints time_pos() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 1;
        return gridBagConstraints;
    }

    private GridBagConstraints buttons_pos() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        return gridBagConstraints;
    }

    private GridBagConstraints pixel_size_pos() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 1;
        return gridBagConstraints;
    }

    private GridBagConstraints blur_pos() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 1;
        return gridBagConstraints;
    }

    private void set_status(String string) {
        this.status.setText("Status: " + string);
    }

    private void set_time(String string) {
        this.time_msg.setText("Estimated time: " + string);
    }

    private synchronized void update_canvas() {
        this.reconstruction_blur_fwhm = this.blur_fwhm.getValue();
        this.zoom = this.pixel_size_in_nm / this.reconstructed_pixel_size.getValue();
        this.linear_reconstruction.setProcessor((ImageProcessor)this.reconstruct());
        this.linear_reconstruction.updateImage();
        this.linear_reconstruction.updateAndRepaintWindow();
        this.canvas.repaint();
        this.canvas.setDrawingSize(this.linear_reconstruction.getWidth(), this.linear_reconstruction.getHeight());
        this.canvas.setSourceRect(new Rectangle(this.linear_reconstruction.getWidth(), this.linear_reconstruction.getHeight()));
        if (this.iterations >= ThreeBGlobalConstants.critical_iterations) {
            this.exportButton.setBackground(this.exportButtonColor);
        } else {
            this.exportButton.setBackground(Color.RED);
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.tbr != null && !this.tbr.has_stopped()) {
            int n = JOptionPane.showConfirmDialog(null, "3B still running! Closing will terminate the run. Really close?", "User Confirmation", 0);
            if (n == 0) {
                this.dispose();
                this.tbr.stop_thread();
            }
        } else {
            this.dispose();
        }
    }

    void export_reconstruction_as_ij() {
        ImageProcessor imageProcessor = this.linear_reconstruction.getProcessor().duplicate();
        ImagePlus imagePlus = new ImagePlus(this.filename + " reconstruction", imageProcessor);
        imagePlus.getCalibration().pixelWidth = this.reconstructed_pixel_size.getValue();
        imagePlus.getCalibration().pixelHeight = this.reconstructed_pixel_size.getValue();
        imagePlus.getCalibration().setXUnit("nm");
        imagePlus.getCalibration().setYUnit("nm");
        imagePlus.show();
        imagePlus.updateAndDraw();
    }

    private synchronized FloatProcessor reconstruct() {
        int n = this.roi.x;
        int n2 = this.roi.y;
        int n3 = (int)Math.ceil((double)this.roi.width * this.zoom);
        int n4 = (int)Math.ceil((double)this.roi.height * this.zoom);
        FloatProcessor floatProcessor = new FloatProcessor(n3, n4);
        for (int i = 0; i < this.pts.size(); ++i) {
            int n5 = (int)Math.floor((this.pts.get((int)i).x - (double)n) * this.zoom + 0.5);
            int n6 = (int)Math.floor((this.pts.get((int)i).y - (double)n2) * this.zoom + 0.5);
            float f = floatProcessor.getPixelValue(n5, n6);
            floatProcessor.putPixelValue(n5, n6, (double)(f + 1.0f));
        }
        double d = this.reconstruction_blur_fwhm / (2.0 * Math.sqrt(2.0 * Math.log(2.0))) * this.zoom / this.pixel_size_in_nm;
        new GaussianBlur().blurGaussian((ImageProcessor)floatProcessor, d, d, 0.005);
        return floatProcessor;
    }

    public void issue_stop() {
        if (this.tbr != null) {
            this.tbr.stop_thread();
        }
        this.stopButton.setEnabled(false);
    }

    public synchronized void append(ArrayList<Spot> arrayList, int n) {
        for (int i = 0; i < arrayList.size(); ++i) {
            this.pts.add(arrayList.get(i));
        }
        this.iterations = n;
    }

    public void send_update_canvas_event() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public final void run() {
                EControlPanel.this.update_canvas();
            }
        });
    }

    public void die(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public final void run() {
                IJ.showStatus((String)"3B run terminated due to an error.\n");
                JOptionPane.showMessageDialog(null, "Error: " + string, "Fatal error", 0);
                EControlPanel.this.dispose();
            }
        });
    }

    public void send_status_text_message(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public final void run() {
                EControlPanel.this.set_status(string);
            }
        });
    }

    public void send_time_text_message(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public final void run() {
                EControlPanel.this.set_time(string);
            }
        });
    }
}

