/*
 * Decompiled with CFR 0.152.
 */
import ij.gui.GenericDialog;
import java.awt.Color;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

class ThreeBDialog
extends GenericDialog {
    int count_;
    int npix;
    int nframes;
    Color c;
    Color bg;

    ThreeBDialog(int n, int n2, int n3) {
        super("3B Analysis");
        this.count_ = n;
        this.npix = n2;
        this.nframes = n3;
        this.addNumericField("Microscope FWHM", 250.0, 1, 10, "nm");
        this.addNumericField("Pixel size", 100.0, 1, 10, "nm");
        this.addNumericField("Initial number of spots", Math.round((double)n / 10.0), 0, 10, "spots");
        this.addNumericField("First frame", 0.0, 0, 10, "");
        this.addNumericField("Last frame", (double)this.nframes - 1.0, 0, 10, "");
        this.addTextAreas("", null, 8, 30);
        this.getTextArea1().setEditable(false);
        this.c = this.getFWHMField().getBackground();
        this.bg = this.getBackground();
        this.getTextArea1().removeTextListener((TextListener)((Object)this));
        this.textValueChanged(null);
    }

    public double parseDouble(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    int parseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    TextField getFWHMField() {
        return (TextField)this.getNumericFields().get(0);
    }

    TextField getPixelSizeField() {
        return (TextField)this.getNumericFields().get(1);
    }

    TextField getSpotsField() {
        return (TextField)this.getNumericFields().get(2);
    }

    TextField getFirstFrameField() {
        return (TextField)this.getNumericFields().get(3);
    }

    TextField getLastFrameField() {
        return (TextField)this.getNumericFields().get(4);
    }

    double getFWHM() {
        return this.parseDouble(this.getFWHMField().getText());
    }

    double getPixelSize() {
        return this.parseDouble(this.getPixelSizeField().getText());
    }

    int getSpots() {
        return this.parseInt(this.getSpotsField().getText());
    }

    int getFirstFrame() {
        return this.parseInt(this.getFirstFrameField().getText());
    }

    int getLastFrame() {
        return this.parseInt(this.getLastFrameField().getText());
    }

    int getCount() {
        return this.count_;
    }

    public void textValueChanged(TextEvent textEvent) {
        boolean bl = false;
        String string = "";
        if (this.getCount() > 1000) {
            bl = true;
            string = string + "Warning: large area selected.\n3B will run very slowly.\n";
        }
        if (this.npix < 2500) {
            string = string + "Warning: image is very small. Fitting may be bad because\nimage noise cannot be accurately estimated.\n";
        }
        if (this.getSpots() > 500) {
            string = string + "Warning: large number of spots.\n3B will run very slowly.\n";
            this.getSpotsField().setBackground(Color.RED);
        } else {
            this.getSpotsField().setBackground(this.c);
        }
        if (this.getFWHM() < 200.0) {
            string = string + "Warning: unrealistically small\nmicsoscope resolution.\n";
            this.getFWHMField().setBackground(Color.RED);
        } else if (this.getFWHM() > 350.0) {
            string = string + "Warning: 3B will not work well with\na poorly focussed microscope.\n";
            this.getFWHMField().setBackground(Color.RED);
        } else {
            this.getFWHMField().setBackground(this.c);
        }
        if (this.getPixelSize() < 70.0) {
            this.getPixelSizeField().setBackground(Color.RED);
            string = string + "Warning: Very small pixels specified.\nAre you sure?\n";
        } else if (this.getPixelSize() > 180.0) {
            this.getPixelSizeField().setBackground(Color.RED);
            string = string + "Warning: 3B will not work well if the camera\nresolution is too poor.\n";
        } else {
            this.getPixelSizeField().setBackground(this.c);
        }
        int n = this.getFirstFrame();
        int n2 = this.getLastFrame();
        int n3 = Math.max(0, Math.min(this.nframes - 1, n));
        int n4 = Math.max(n3, Math.min(this.nframes - 1, n2));
        if (n != n3) {
            this.getFirstFrameField().setText(Integer.toString(n3));
        }
        if (n2 != n4) {
            this.getLastFrameField().setText(Integer.toString(n4));
        }
        if (n2 - n + 1 > 500) {
            this.getFirstFrameField().setBackground(Color.RED);
            this.getLastFrameField().setBackground(Color.RED);
            string = string + "Warning: large number of frames specified.\n3B will run very slowly and may be inaccurate.\nFewer than 500 frames is strongly recommended.\n200--300 is generally most suitable.\n";
            bl = true;
        }
        if (n2 - n + 1 < 150) {
            this.getFirstFrameField().setBackground(Color.RED);
            this.getLastFrameField().setBackground(Color.RED);
            string = string + "Warning: small number of frames specified.\n3B may be inaccurate.\nAt least 150 frames is recommended.\n";
        } else {
            this.getFirstFrameField().setBackground(this.c);
            this.getLastFrameField().setBackground(this.c);
        }
        if (!bl && (n2 - n + 1) * this.getCount() > 200000) {
            string = string + "Warning: large amount of data specified.\n" + "3B will run very slowly.\n" + "Reduce the area and/or number of frames.\n" + "We recommend: \n" + "Number of frames*area in pixels < 200,000.";
            this.getFirstFrameField().setBackground(Color.RED);
            this.getLastFrameField().setBackground(Color.RED);
        }
        if (!string.equals("")) {
            this.getTextArea1().setBackground(Color.RED);
        } else {
            this.getTextArea1().setBackground(this.bg);
        }
        this.getTextArea1().setText(string);
        this.repaint();
    }
}

