/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImageStack;
import ij.process.ByteProcessor;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.swing.JOptionPane;

class ThreeBRunner
implements Runnable {
    ByteProcessor mask;
    float[][] pixels;
    private volatile boolean stop = false;
    private volatile boolean stopped = false;
    private boolean fatal = false;
    EControlPanel cp;
    String config;
    String filename;
    long start_time;
    int its;

    ThreeBRunner(ByteProcessor byteProcessor, ImageStack imageStack, String string, String string2, int n, int n2) {
        this.config = string;
        this.filename = string2;
        this.mask = (ByteProcessor)byteProcessor.duplicate();
        this.pixels = new float[n2 - n + 1][];
        for (int i = n; i <= n2; ++i) {
            this.pixels[i - n] = (float[])imageStack.getProcessor(i + 1).convertToFloat().getPixels();
        }
    }

    public void register(EControlPanel eControlPanel) {
        this.cp = eControlPanel;
    }

    void stop_thread() {
        this.stop = true;
        this.send_message_string("stopping...");
    }

    boolean has_stopped() {
        return this.stopped;
    }

    void send_message_string(String string) {
        this.cp.send_status_text_message(string);
    }

    void send_new_points(float[] fArray) {
        ArrayList<Spot> arrayList = new ArrayList<Spot>();
        for (int i = 0; i < fArray.length; i += 2) {
            Spot spot = new Spot();
            spot.x = fArray[i];
            spot.y = fArray[i + 1];
            arrayList.add(spot);
        }
        this.cp.append(arrayList, this.its);
        this.cp.send_update_canvas_event();
        long l = new Date().getTime();
        if (this.its > 0) {
            if (this.its < 8) {
                this.cp.send_time_text_message("computing...");
            } else {
                long l2 = (l - this.start_time) / (long)this.its;
                int n = (int)Math.ceil((double)this.its * 1.0 / (double)ThreeBGlobalConstants.critical_iterations) * ThreeBGlobalConstants.critical_iterations;
                int n2 = n - this.its;
                System.out.println("Its = " + this.its);
                System.out.println("rem = " + n2);
                System.out.println("time_per_it = " + l2);
                long l3 = (long)n2 * l2 / 1000L;
                long l4 = l3 % 60L;
                long l5 = l3 / 60L % 60L;
                long l6 = l3 / 3600L;
                this.cp.send_time_text_message(l6 + "h" + l5 + "m (for " + n + " iterations)");
            }
        }
        ++this.its;
    }

    void die(String string) {
        this.cp.die(string);
        this.fatal = true;
    }

    boolean should_stop() {
        return this.stop;
    }

    native void call(String var1, float[][] var2, byte[] var3, int var4, int var5, int var6, String var7);

    @Override
    public void run() {
        System.out.println("About to call...");
        this.start_time = new Date().getTime();
        this.its = 0;
        this.call(this.config, this.pixels, (byte[])this.mask.getPixels(), this.pixels.length, this.mask.getHeight(), this.mask.getWidth(), this.filename);
        System.out.println("Finished.");
        if (!this.fatal) {
            this.cp.send_status_text_message("Finished\n");
            IJ.showStatus((String)"3B run terminated");
        }
        this.stopped = true;
    }

    private static String decodePercent(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '+') {
                stringBuffer.append(' ');
                continue;
            }
            if (c == '%') {
                stringBuffer.append((char)Integer.parseInt(string.substring(i + 1, i + 3), 16));
                i += 2;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static void addLibraryPath(String string) throws Exception {
        String[] stringArray;
        Field field = ClassLoader.class.getDeclaredField("usr_paths");
        field.setAccessible(true);
        for (String string2 : stringArray = (String[])field.get(null)) {
            if (!string2.equals(string)) continue;
            return;
        }
        String[] stringArray2 = Arrays.copyOf(stringArray, stringArray.length + 1);
        stringArray2[stringArray2.length - 1] = string;
        field.set(null, stringArray2);
    }

    static String get_plugin_dir() {
        try {
            String string = new SPair().getClass().getResource("img").getFile();
            URI uRI = null;
            uRI = new URI(string.substring(0, string.length() - 5));
            File file = new File(uRI);
            System.out.println("File: " + file.getCanonicalPath());
            String string2 = file.getParentFile().getCanonicalPath() + File.separator;
            System.out.println("Dir: " + string2);
            return string2;
        }
        catch (Exception exception) {
            return "";
        }
    }

    static UnsatisfiedLinkError try_to_load_dlls(String[] stringArray) {
        String string = ThreeBRunner.get_plugin_dir();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("Loading " + string + stringArray[i]);
                System.load(string + stringArray[i]);
            }
            return null;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("Link error: " + unsatisfiedLinkError.getMessage());
            return unsatisfiedLinkError;
        }
    }

    static {
        block2: {
            String string = ThreeBRunner.get_plugin_dir();
            String[] stringArray = new String[]{"threeB_jni.dll"};
            String[] stringArray2 = new String[]{"libthreeB_jni_32.so"};
            String[] stringArray3 = new String[]{"libthreeB_jni_64.so"};
            try {
                System.out.println("Trying to load the normal way...");
                System.loadLibrary("threeB_jni");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.out.println("First error: " + unsatisfiedLinkError.getMessage());
                String string2 = unsatisfiedLinkError.getMessage();
                UnsatisfiedLinkError unsatisfiedLinkError2 = unsatisfiedLinkError;
                System.out.println("Trying manual loading...");
                UnsatisfiedLinkError unsatisfiedLinkError3 = ThreeBRunner.try_to_load_dlls(stringArray3);
                if (unsatisfiedLinkError3 == null) break block2;
                string2 = string2 + "\n" + unsatisfiedLinkError3.getMessage();
                unsatisfiedLinkError3 = ThreeBRunner.try_to_load_dlls(stringArray2);
                if (unsatisfiedLinkError3 == null) break block2;
                string2 = string2 + "\n" + unsatisfiedLinkError3.getMessage();
                unsatisfiedLinkError3 = ThreeBRunner.try_to_load_dlls(stringArray);
                if (unsatisfiedLinkError3 == null) break block2;
                string2 = string2 + "\n" + unsatisfiedLinkError3.getMessage();
                JOptionPane.showMessageDialog(null, "Error loading plugin:\n" + string2, "Error loading plugin", 0);
                throw unsatisfiedLinkError2;
            }
        }
    }
}

